require File.expand_path('../../spec_helper', __FILE__)

describe BulkTimeEntriesController, :logged => :admin do

  let(:project) { FactoryGirl.create(:project) }
  let(:issue) { FactoryGirl.create(:issue, :project => project) }
  let(:time_entry_activity) { FactoryGirl.create(:time_entry_activity, :project => project, :projects => [project]) }

  describe 'POST /bulk_time_entries' do

    it 'create time_entry' do
      expect {
        post :save, {:user_id => User.current.id, :project_id => project.id, :spent_on => Date.today.to_s, :time_entry => {:hours => nil, :easy_time_entry_range => {:from => '10.00', :to => '11:30'}, :activity_id => time_entry_activity.id, :comments => 'Bla Bla'}}
      }.to change(TimeEntry, :count).by(1)
      time_entry = TimeEntry.last
      expect(time_entry.hours).to eq(1.5)
      expect(time_entry.easy_range_from).not_to be_nil
      expect(time_entry.easy_range_to).not_to be_nil
    end

  end

end
