desc 'Generates initializers that changes plugins order'

namespace :easyproject do

  task :change_plugins_order do
    path = File.join(Rails.root, 'config', 'initializers', '22-change_plugins_order.rb')
    File.open(path, 'w') do |f|
      f.write <<"EOF"
require 'redmine/plugin'
module Redmine
  class Plugin

    def self.load
      directory = File.join(self.directory, 'easyproject')
      if File.directory?(directory)
        lib = File.join(directory, 'lib')
        if File.directory?(lib)
          $:.unshift lib
          ActiveSupport::Dependencies.autoload_paths += [lib]
        end
        initializer = File.join(directory, 'init.rb')
        if File.file?(initializer)
          require initializer
        end
      end
    end
  end

end
EOF
    end
  end

end
