require 'redmine/scm/adapters/subversion_adapter'

module EasyPatch
  module ScmSubversionAdapterPatch

    def self.included(base)
      base.send(:include, InstanceMethods)

      base.class_eval do
        alias_method_chain :credentials_string, :easy_extensions
      end
    end

    module InstanceMethods
      def credentials_string_with_easy_extensions
        str = credentials_string_without_easy_extensions
        str << ' --trust-server-cert' if EasySetting.value('dont_verify_server_cert')
        str
      end
    end
  end
end
EasyExtensions::PatchManager.register_other_patch 'Redmine::Scm::Adapters::SubversionAdapter', 'EasyPatch::ScmSubversionAdapterPatch'
