module EasyPatch
  module UserPreferencePatch

    def self.included(base)
      base.extend(ClassMethods)
      base.include InstanceMethods
      base.include Redmine::SafeAttributes # redmine 3.4

      base.class_eval do

        safe_attributes 'hide_mail',
          'time_zone',
          'comments_sorting',
          'warn_on_leaving_unsaved',
          'no_self_notified',
          'textarea_font',
          'no_notification_ever',
          'number_alignment',
          'user_theme',
          'disable_automatic_loading',
          'no_notified_if_issue_closing',
          'last_easy_attendance_arrival_date',
          'display_journal_details',
          'global_time_entries_visibility'

        def no_notified_if_issue_closing;
          (self[:no_notified_if_issue_closing] == true || self[:no_notified_if_issue_closing] == '1');
        end

        def no_notified_if_issue_closing=(value)
          self[:no_notified_if_issue_closing]=value
        end

        def no_notification_ever
          (self[:no_notification_ever] == true || self[:no_notification_ever] == '1')
        end

        def no_notification_ever=(value)
          self[:no_notification_ever]=value
        end

        def number_alignment;
          self[:number_alignment] || '0'
        end

        def number_alignment=(value)
          self[:number_alignment]=value
        end

        def user_theme
          self[:user_theme]
        end

        def user_theme=(value)
          self[:user_theme]=value
        end

        def disable_automatic_loading
          self[:disable_automatic_loading].to_s.to_boolean
        end

        def disable_automatic_loading=(value)
          self[:disable_automatic_loading]=value
        end

        def last_easy_attendance_arrival_date
          self[:last_easy_attendance_arrival_date]
        end

        def last_easy_attendance_arrival_date=(value)
          self[:last_easy_attendance_arrival_date] = value
        end

        def display_journal_details
          # if self[:display_journal_details].present?
          #   self[:display_journal_details] == true || self[:display_journal_details] == '1'
          # else
          #   EasySetting.value('display_journal_details')
          # end

          true
        end

        def display_journal_details=(value)
          self[:display_journal_details]=value
        end

        def global_time_entries_visibility
          self[:global_time_entries_visibility].to_s.to_boolean
        end

        def global_time_entries_visibility=(value)
          self[:global_time_entries_visibility]=value
        end

      end
    end

    module InstanceMethods
    end

    module ClassMethods
    end

  end

end
EasyExtensions::PatchManager.register_model_patch 'UserPreference', 'EasyPatch::UserPreferencePatch'
