module EasyPatch
  module IssueCategoryPatch

    def self.included(base)
      base.send(:include, Redmine::NestedSet::Traversing)

      base.class_eval do
        safe_attributes 'parent_id'
        acts_as_nested_set :order => 'name', :dependent => :destroy, :scope => 'project_id'
      end
    end
  end

end
EasyExtensions::PatchManager.register_model_patch 'IssueCategory', 'EasyPatch::IssueCategoryPatch'
