module EasyPatch
  module SortHelperPatch

    def self.included(base)
      base.send(:include, InstanceMethods)

      base.class_eval do

        alias_method_chain :sort_update, :easy_extensions
        alias_method_chain :sort_css_classes, :easy_extensions

      end
    end

    module InstanceMethods

      def sort_update_with_easy_extensions(criteria, sort_name=nil)
        sort_update_without_easy_extensions(criteria, sort_name)
        if @query
          @query.sort_criteria = Array(@sort_criteria)
        end
      end

      def sort_css_classes_with_easy_extensions
        @sort_criteria.nil? ? '' : sort_css_classes_without_easy_extensions
      end

    end

  end
end
EasyExtensions::PatchManager.register_helper_patch 'SortHelper', 'EasyPatch::SortHelperPatch'
