module EasyPatch
  module SysControllerPatch

    def self.included(base)

      base.class_eval do

        def git_fetcher
          options = { project_id: params[:id], fetch_all: params[:fetch_all].presence }
          EasyExtensions::EasyJobs::GitFetcherTask.perform_async(options)
          render nothing: true, status: 200
        end

      end
    end

  end
end
EasyExtensions::PatchManager.register_controller_patch 'SysController', 'EasyPatch::SysControllerPatch'
