module EasyPatch
  module IssueStatusesControllerPatch

    def self.included(base)
      base.send(:include, InstanceMethods)
      base.class_eval do

        alias_method_chain :require_admin, :easy_extensions
        alias_method_chain :require_admin_or_api_request, :easy_extensions
        alias_method_chain :update, :easy_extensions

      end
    end

    module InstanceMethods

      def update_with_easy_extensions
        @issue_status = IssueStatus.find(params[:id])
        if @issue_status.update_attributes(params[:issue_status])
          respond_to do |format|
            format.html {
              flash[:notice] = l(:notice_successful_update)
              redirect_to issue_statuses_path(:page => params[:page])
            }
            format.js { render :nothing => true }
            format.api { render_api_ok }
          end
        else
          respond_to do |format|
            format.html { render :action => 'edit' }
            format.js { render :nothing => true, :status => 422 }
            format.api { render_validation_errors(@issue_status) }
          end
        end
      end

      def require_admin_with_easy_extensions
        require_admin_or_lesser_admin(:issue_statuses)
      end

      def require_admin_or_api_request_with_easy_extensions
        require_admin_or_api_request_or_lesser_admin(:issue_statuses)
      end

    end

  end

end
EasyExtensions::PatchManager.register_controller_patch 'IssueStatusesController', 'EasyPatch::IssueStatusesControllerPatch'
