module EasyPatch
  module CustomFieldEnumerationsControllerPatch
    def self.included(base)
      base.send(:include, InstanceMethods)

      base.class_eval do

        alias_method_chain :create, :easy_extensions

      end

    end

    module InstanceMethods

      def create_with_easy_extensions
        @value = @custom_field.enumerations.build(params[:custom_field_enumeration])
        if @value.save
          respond_to do |format|
            format.html { redirect_to custom_field_enumerations_path(@custom_field) }
            format.js
          end
        else

          respond_to do |format|
            format.html { redirect_to custom_field_enumerations_path(@custom_field), alert: @value.errors.full_messages.join('<br>').html_safe }
            format.js { render :text => "window.showFlashMessage('error', '#{@value.errors.full_messages.join('<br>').html_safe}', 1000);" }
          end
        end
      end
    end

  end
end

EasyExtensions::PatchManager.register_controller_patch 'CustomFieldEnumerationsController', 'EasyPatch::CustomFieldEnumerationsControllerPatch'

