module EasyPatch
  module AccountControllerPatch

    def self.included(base)
      base.send(:include, InstanceMethods)
      base.class_eval do

        helper :attachments
        include AttachmentsHelper

        accept_api_auth :autologin

        before_action :set_self_registered_on_user, only: :register
        # before_action :resolve_layout, :except => [:get_avatar]

        alias_method_chain :successful_authentication, :easy_extensions

        def autologin
          if Setting.rest_api_enabled? && accept_api_auth? && (key = api_key_from_request)
            if (user = User.find_by_api_key(key))
              self.logged_user = user
              set_autologin_cookie(user)
            end
          end

          redirect_back_or_default(home_url)
        end

        def quotes
          quote_engine = EasyExtensions.easy_quotes_engine_instance
          @quote = quote_engine.get_quote
          call_hook(:controller_account_action_quotes_before_render, {:quote => @quote})

          respond_to do |format|
            format.json { render(:json => @quote.to_json) }
            format.xml { render(:xml => @quote.to_xml) }
            format.text { render(:text => @quote.to_s) }
          end
        end

        def reset_easy_digest_token
          password = params[:password]

          if User.current.check_password?(password)
            User.current.send(:update_easy_digest_token, password, true)
            flash[:notice] = l(:notice_easy_digest_token_updated)
          else
            flash[:error] = l(:notice_account_wrong_password)
          end

          redirect_back_or_default(home_url)
        end

        def my_account_path
          if User.current.allowed_to_globally?(:edit_profile)
            super
          else
            profile_user_path(User.current)
          end
        end

        private

        def resolve_layout
          # if (in_mobile_view? || params[:format] == :mobile)
          #   self.class.layout 'login', :formats => :mobile
          # else
          self.class.layout 'base'
          # end
        end

        def set_self_registered_on_user
          params[:user].merge!({:self_registered => true}) unless request.get?
        end

        def update_sso_columns(user)
          if sso = session.delete(:sso)
            user.update_columns(sso_provider: sso[:sso_provider], sso_uuid: sso[:sso_uuid], easy_avatar_url: sso[:easy_avatar_url])

            if !sso[:email].blank?
              user.email_addresses.create(address: sso[:email], notify: false) if !user.email_addresses.where(address: sso[:email]).exists?
            end
          end
        end

      end
    end

    module InstanceMethods

      def successful_authentication_with_easy_extensions(user)
        update_sso_columns(user)
        successful_authentication_without_easy_extensions(user)
      end

    end

  end
end
EasyExtensions::PatchManager.register_controller_patch 'AccountController', 'EasyPatch::AccountControllerPatch'
