module EasyPatch
  module AssetUrlHelperPatch

    def self.included(base)
      base.send(:include, InstanceMethods)
      base.class_eval do

        # alias_method_chain :asset_path, :easy_extensions
        # alias_method_chain :path_to_asset, :easy_extensions

        class << self

        end

        private

        def add_timestamp(source)
          unless source.include?('?')
            file = File.join(config.assets_dir, source)
            source.concat("?#{File.mtime(file).strftime('%Y%m%d%H%M%S')}") if File.exists?(file)
          end

          source
        end

      end
    end

    module InstanceMethods

      def asset_path_with_easy_extensions(source, options = {})
        path = asset_path_without_easy_extensions(source, options)

        add_timestamp(path)
      end

      def path_to_asset_with_easy_extensions(source, options = {})
        path = path_to_asset_without_easy_extensions(source, options)
        add_timestamp(path)
      end

    end

  end
end
EasyExtensions::PatchManager.register_rails_patch  'ActionView::Helpers::AssetUrlHelper', 'EasyPatch::AssetUrlHelperPatch'
