Redmine::AccessControl.update_permission :add_project, {}, :global => true
Redmine::AccessControl.update_permission :close_project, {:projects => [:bulk_close, :bulk_reopen]}
Redmine::AccessControl.update_permission :add_issues, {:my => [:new_my_page_create_issue], :issues => [:new_for_dialog]}
Redmine::AccessControl.update_permission :add_documents, {:documents => [:select_project]}
Redmine::AccessControl.update_permission :edit_documents, {:documents => [:select_project]}
Redmine::AccessControl.update_permission :edit_issues, {:easy_issues => [:description_edit, :description_update, :edit_toggle_description]}
Redmine::AccessControl.update_permission :view_time_entries, {:bulk_time_entries => [:index, :load_users, :load_assigned_projects, :load_assigned_issues, :load_fixed_activities, :select_issue]}, :global => true
Redmine::AccessControl.update_permission :view_news, {}, {:public => false}
Redmine::AccessControl.update_permission :log_time, {:bulk_time_entries => [:index, :load_users, :load_assigned_projects, :load_assigned_issues, :load_fixed_activities, :save, :show, :new], :timelog => [:change_projects_for_bulk_edit, :change_issues_for_bulk_edit, :change_role_activities], :easy_issue_timers => [:play, :stop, :pause, :destroy]}
Redmine::AccessControl.update_permission :view_project, {:projects => [:load_allowed_parents, :favorite], :activities => []}
Redmine::AccessControl.update_permission :manage_categories, {:issue_categories => [:move_category]}
Redmine::AccessControl.update_permission :view_issues, {:easy_issues => [:find_by_user, :favorite, :render_tab], :easy_report_issues => [:index]}
Redmine::AccessControl.update_permission :select_project_modules, {:projects => [:easy_custom_menu_toggle], :easy_custom_project_menus => [:index, :show, :new, :create, :edit, :update, :destroy]}
Redmine::AccessControl.update_permission :save_queries, {:easy_queries => [:new, :create, :edit, :update, :destroy]}, :require => :loggedin

Redmine::AccessControl.map do |map|

  map.permission :manage_page_project_overview, {:projects => :personalize_show}

  map.permission :archive_project, {:projects => [:archive, :unarchive, :bulk_archive, :bulk_unarchive]}, :read => true
  map.permission :delete_project, {:projects => [:destroy, :bulk_destroy]}
  map.permission :edit_own_projects, {:projects => [:settings, :edit, :update, :easy_custom_menu_toggle], :easy_custom_project_menus => [:index, :show, :new, :create, :edit, :update, :destroy]}, :require => :loggedin, :global => true
  map.permission :edit_project_custom_fields, {:projects => [:edit_custom_fields_form, :update_custom_fields_form]}, :require => :member
  map.permission :create_project_from_template, {:templates => :index}, :read => true, :global => true
  map.permission :create_subproject_from_template, {:templates => :index}, :read => true
  map.permission :create_project_template, {:templates => [:new, :create]}
  map.permission :edit_project_template, {}, :global => true
  map.permission :delete_project_template, {:templates => [:destroy, :bulk_destroy]}, :global => true
  map.permission :view_project_activity, { :activities => [:index], :easy_activities => [:show_toolbar, :show_selected_event_type, :discart_all_events, :events_from_activity_feed_module, :get_current_user_activities_count] }, :read => true
  map.permission :view_project_report, { :reports => :issue_report, :easy_report_issues => [:index] }, :read => true
  map.permission :edit_issue_fixed_activity, {}
  map.permission :copy_project, {:projects => [:copy]}, :read => true
  #map.permission :manage_easy_project_relations, {:easy_project_relations => [:destroy]}, :global => true
  map.permission :manage_easy_version_relations, {:easy_version_relations => [:destroy]}
  map.permission :view_project_overview_users_query, {}, :read => true
  map.permission :manage_bulk_version, {:versions => [:bulk_edit, :bulk_update, :bulk_destroy]}

  map.permission :manage_global_versions, {:easy_versions => [:index, :new, :create]}, :global => true

  map.permission :manage_easy_issue_timers, {:easy_issue_timers => [:settings, :update_settings]}

  map.permission :create_comments, :global => true
  map.permission :manage_comments, :global => true
  map.permission :delete_own_comments, :global => true

  map.permission :manage_easy_broadcasts, {easy_broadcasts: [:index, :show, :new, :create, :edit, :update, :destroy, :context_menu] }, global: true

  map.project_module :issue_tracking do |pmap|
    # pmap.permission :view_restrictions_users, {}, :read => true
    pmap.permission :edit_own_issue, {:issues => [:edit, :update, :bulk_edit, :bulk_update],
      :easy_issues => [:description_edit, :description_update, :edit_toggle_description], :attachments => :upload}
    pmap.permission :edit_assigned_issue, {:issues => [:edit, :update, :bulk_edit, :bulk_update],
      :easy_issues => [:description_edit, :description_update, :edit_toggle_description], :attachments => :upload}
    pmap.permission :move_issues, {:issue_moves => [:available_issues], :easy_issues => [:move_to_project] }
    pmap.permission :edit_repeating_options_on_issue, {}
    pmap.permission :edit_without_notifications, {}
  end

  map.project_module :news do |pmap|
    pmap.permission :manage_own_news, {:news => [:new, :create, :edit, :update, :destroy], :comments => [:destroy], :attachments => :upload}, :require => :member
  end

  map.project_module :time_tracking do |pmap|
    pmap.permission :view_personal_statement, {:timelog => :index}, :read => true, :global => true
    pmap.permission :view_estimated_hours, {}, :read => true
    pmap.permission :add_timeentries_for_other_users, {}, :global => true
    pmap.permission :add_timeentries_for_other_users_on_project, {}
    pmap.permission :timelog_can_easy_locking, {:timelog => :resolve_easy_lock}, :global => true
    pmap.permission :timelog_can_easy_unlocking, {:timelog => :resolve_easy_lock}, :global => true
  end

  map.project_module :easy_attendances do |pmap|
    pmap.permission :view_easy_attendances, {:easy_attendances => [:index, :show, :report, :statuses, :overview]}, :read => true, :require => :loggedin, :global => true
    pmap.permission :use_easy_attendances, {:easy_attendances => [:new, :create, :edit, :update, :arrival, :departure]}, :require => :loggedin, :global => true
    pmap.permission :edit_easy_attendances, {:easy_attendances => [:edit, :bulk_update, :arrival, :departure]}, :require => :loggedin, :global => true
    pmap.permission :edit_own_easy_attendances, {:easy_attendances => [:edit, :bulk_update, :arrival, :departure]}, :require => :loggedin, :global => true
    pmap.permission :cancel_own_easy_attendances, {:easy_attendances => [:bulk_cancel]}, :require => :loggedin, :global => true
    pmap.permission :delete_easy_attendances, {:easy_attendances => [:destroy, :bulk_destroy]}, :require => :loggedin, :global => true
    pmap.permission :delete_own_easy_attendances, {:easy_attendances => [:destroy, :bulk_destroy]}, :require => :loggedin, :global => true
    pmap.permission :view_easy_attendances_extra_info, {}, :read => true, :global => true
    pmap.permission :view_easy_attendance_other_users, {:easy_attendances => [:detailed_report]}, :read => true, :global => true
    pmap.permission :edit_easy_attendance_approval, {:easy_attendances => [:edit, :approval_save, :approval]}, :global => true
  end

  map.project_module :easy_other_permissions do |pmap|
    pmap.permission :view_easy_resource_booking_module, {:easy_resource_availabilities => [:index]}, :global => true
    pmap.permission :manage_easy_resource_booking_module, {:easy_resource_availabilities => [:layout]}, :global => true
    pmap.permission :manage_easy_resource_booking_availability, {}, :global => true
    pmap.permission :manage_my_page, {:my => [:page_layout]}, :global => true
    pmap.permission :edit_profile, {:my => [:account]}, :global => true
    pmap.permission :view_issue_timers_of_others, {}, :global => true
    pmap.permission :view_custom_dashboards, {:easy_pages => [:custom_easy_page]}, :global => true
    pmap.permission :manage_custom_dashboards, {:easy_pages => [:custom_easy_page, :custom_easy_page_layout]}, :global => true
  end

end
