require 'easy_extensions/easy_mail_template'

module EasyExtensions
  class EasyMailTemplateIssue < EasyExtensions::EasyMailTemplate

    def self.get_external_emails_from_entity(issue)
      issue.custom_field_value(EasyExtensions.cf_external_mails_id)
    end

    def add_issue_history(issue)
      @mail_body_html << issue.get_issue_history if Setting.text_formatting == 'HTML'
    end
  end
end
