class CreateEasyBroadcasts < ActiveRecord::Migration
  def change
    create_table :easy_broadcasts, force: true do |t|
      t.text :message, null: false
      t.datetime :start_at, null: false
      t.datetime :end_at, null: false
      t.belongs_to :author, null: false

      t.index :start_at
      t.index :end_at

      t.timestamps null: false
    end

    create_table :easy_broadcasts_user_types, id: false, force: true do |t|
      t.integer :easy_broadcast_id
      t.integer :easy_user_type_id

      t.index :easy_user_type_id
      t.index [:easy_broadcast_id, :easy_user_type_id], name: 'idx_easy_broadcast_user_type', unique: true
    end

  end
end