class CreateCustomFieldsEnumerations < ActiveRecord::Migration
  def self.up
    create_table :custom_fields_enumerations, :id => false do |t|
      t.column :custom_field_id, :integer, :null => false
      t.column :enumeration_id, :integer, :null => false
    end
    add_index :custom_fields_enumerations, [:custom_field_id, :enumeration_id], :unique => true, :name => :custom_fields_enumerations_ids
    CustomField.where({:type => 'TimeEntryCustomField'}).update_all({:visible => true})
  end

  def self.down
    drop_table :custom_fields_enumerations
  end
end
