class CreateCustomFieldsEasyUserTypes < ActiveRecord::Migration
  def self.up
    create_table :custom_fields_easy_user_types, :id => false do |t|
      t.column :custom_field_id, :integer, :null => false
      t.column :easy_user_type_id, :integer, :null => false
    end
    add_index :custom_fields_easy_user_types, [:custom_field_id, :easy_user_type_id], :unique => true, :name => :custom_fields_easy_user_types_ids
    CustomField.where({:type => 'UserCustomField'}).update_all({:visible => true})
  end

  def self.down
    drop_table :custom_fields_easy_user_types
  end
end
