/*!
 * jQuery Color Animations v2.0pre
 * http://jquery.org/
 *
 * Copyright 2011 John Resig
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 */

(function( $, undefined ) {

  $.widget("easy.fullScreen", {
    options: {
      openButton: null,
      label_close: 'X',
      title_close: '',
      buttonsToClone: null,
      buttonsContainer: null
    },

    _create: function() {
      var self = this;
      if( this.options.openButton )
        this.options.openButton.click(function(evt){
          evt.preventDefault();
          self.open();
        });

      this.element.on('fscreenclose', function(e) {
        self.close();
      });
    },

    _afterSwitch: function( type ) {
      this._trigger(type);
    },

    _fullscreenButtons: function(container_id) {
      if( !this.options.buttonsToClone || this.options.buttonsToClone.length < 1 )
        return;

      var self = this;
      // var a = $("<a/>").attr({
      //     'title': this.options.title_close,
      //     'class' : 'button'
      // }).click(function(){
      //   self.close();
      // }).html(this.options.label_close);

      this.fullButtons = $('<div/>');
      var buttons = $("<div/>", {'class':'fs-buttons'})
        .css({'float': 'right', 'z-index' : '10001'})
        .append( this.options.buttonsToClone.clone().css({'margin': 10}) );
      this.fullButtons.append( buttons );
      // this.fullButtons.append( $('<div class="clear"></div>') );

      container = this.element;
      if( this.options.buttonsContainer )
        container = $(this.options.buttonsContainer);

      container.prepend(this.fullButtons);
    },

    open: function() {
      var self = this;
      this.element.fullscreen();
      this.element.data('cssBeforeFull', {'margin': this.element.css('margin'), 'top': this.element.css('top')} )
      this.element.css({'margin': 10, 'top': 0, 'width': '', 'height': ''});
      // $("#footer, #header, #indent-box, #top-menu, #easy_servicebar").hide();

      this._fullscreenButtons('fullscreen-close');
      this.element.data('scrollTopWas', $('#content').scrollTop());
      $('#content').scrollTop(0);

      setTimeout(function(){
        self._afterSwitch('open');
      });
    },

    close: function() {
      var self = this;
      // $("#footer, #header, #indent-box, #top-menu, #easy_servicebar").show();
      // $('#main').removeAttr('style');
      if( this.fullButtons)
        this.fullButtons.remove();
      $('#content').scrollTop(this.element.data('scrollTopWas'));

      this.element.removeAttr("style");
      this.element.css( this.element.data('cssBeforeFull') );

      this.element.removeData('cssBeforeFull');
      this.element.removeData('scrollTopWas');

      setTimeout( function () {
        self._afterSwitch('close');
      }, 200);
    }

  });

})( jQuery );
