class EasyReportIssueStatus < ActiveRecord::Base

  NO_OF_COLUMNS = 29

  belongs_to :issue

  attr_protected :id

  def status_map
    EasyReportSetting.where(:name => 'EasyReportIssueStatus').first
  end

  def status_map_settings
    RequestStore.store[:status_map_settings] ||= (self.status_map && self.status_map.settings) || {}
  end

  def get_idx(id)
    status_map_settings[:map][id] if id && status_map_settings[:map]
  end

  def get_status_time(idx)
    read_attribute("status_time_#{idx}") if idx.to_i <= NO_OF_COLUMNS
  end

  def set_status_time(idx, value)
    write_attribute("status_time_#{idx}", value)
  end

  def get_status_count(idx)
    read_attribute("status_count_#{idx}") if idx.to_i <= NO_OF_COLUMNS
  end

  def set_status_count(idx, value)
    write_attribute("status_count_#{idx}", value)
  end

  def set_all_columns_to_nil
    0.upto(NO_OF_COLUMNS).each do |idx|
      set_status_time(idx, nil)
      set_status_count(idx, nil)
    end
  end

end
