class EasyPageQuery < EasyQuery

  def initialize_available_filters
    group = l("label_filter_group_#{self.class.name.underscore}")

    add_available_filter 'identifier', {:type => :string, :group => group, :name => EasyPage.human_attribute_name(:identifier)}
    add_available_filter 'tags', {:type => :list, :values => Proc.new{all_tags_values}, :includes => [:tags], :label => :label_easy_tags, :group => group}
  end

  def available_columns
    unless @available_columns_added
      group = l("label_filter_group_#{self.class.name.underscore}")

      @available_columns = [
          EasyQueryColumn.new(:identifier, :sortable => "#{EasyPage.table_name}.identifier", :title => EasyPage.human_attribute_name(:identifier), :group => group),
          EasyQueryColumn.new(:url, :sortable => false, :title => EasyPage.human_attribute_name(:url), :group => group),
          EasyQueryColumn.new(:translated_name, :sortable => false, :title => EasyPage.human_attribute_name(:translated_name), :group => group),
          EasyQueryColumn.new(:page_scope, :sortable => "#{EasyPage.table_name}.page_scope", :title => EasyPage.human_attribute_name(:page_scope), :group => group)
      ]

      @available_columns << EasyQueryColumn.new(:tags, :preload => [:tags], :caption => :label_easy_tags, :group => group)

      @available_columns_added = true
    end
    @available_columns
  end

  def searchable_columns
    ["#{EasyPage.table_name}.identifier"]
  end

  def default_list_columns
    super.presence || ['identifier', 'url', 'translated_name', 'page_scope']
  end

  def entity
    EasyPage
  end

  def entity_scope
    @entity_scope ||= EasyPage.for_index
  end

end
