class EpmProjectNews < EasyPageModule

  def permissions
    @permissions ||= [:view_news]
  end

  def category_name
    @category_name ||= 'others'
  end

  def get_show_data(settings, user, page_context = {})
    if page_zone_module && !page_zone_module.entity_id.blank?
      project = page_context[:project] || Project.find(page_zone_module.entity_id)
      news = project.news.joins(:project).preload(:project, :author).where(Project.allowed_to_condition(user, :view_news)).order("#{News.table_name}.spinned DESC, #{News.table_name}.created_on DESC").limit(5).all

      return {:project => project, :news => news}
    end
  end

#  def module_allowed?(user = nil)
#    if page_zone_module && !page_zone_module.entity_id.blank?
#      project = Project.find(page_zone_module.entity_id)
#      if project.module_enabled?(:news).nil?
#        return false
#      end
#      user ||= User.current
#
#      if self.permissions.blank?
#        perm = true
#      else
#        perm = self.permissions.inject(true) do |allowed, perm|
#          allowed && user.allowed_to?(perm, project)
#        end
#      end
#
#      return false unless perm
#
#      return (runtime_permissions(user) == true)
#    else
#      super
#    end
#  end
end
