class EpmProjectInfo < EasyPageModule

  def category_name
    @category_name ||= 'projects'
  end

  def get_show_data(settings, user, page_context = {})
    if page_zone_module && !page_zone_module.entity_id.blank?
      project = page_context[:project] || Project.find(page_zone_module.entity_id)

      return {:project => project}
    end
  end

  def get_edit_data(settings, user, page_context = {})
    groups = ['all']
    project = get_show_data(settings, user, page_context)
    project[:project].visible_custom_field_values.each do |value|
      if value.custom_field.easy_group && !groups.include?(value.custom_field.easy_group)
        groups << value.custom_field.easy_group
      end
    end if project[:project]
    {:groups => groups}
  end

end
