class EpmActivityFeed < EasyPageModule

  def category_name
    @category_name ||= 'others'
  end

  def get_show_data(settings, user, page_context = {})
    events = self.class.events_for_settings(settings)
    total_count = events.count

    row_limit = settings['row_limit'].nil? ? 10 : settings['row_limit'].to_i

    return {:events => events.take(row_limit), :total_count => total_count}
  end

  def get_edit_data(settings, user, page_context = {})
    {}
  end

  def self.event_types_for_settings(settings, user=User.current)
    scope = EasyActivity::ALL_SCOPE
    scope = settings['activity_scope'].first if settings['activity_scope']

    options = {}
    options[:selected_event_types] = settings['selected_event_types']
    options = EasyActivity.set_scope_for_options(scope, User.current, options)
    options[:selected_event_types].to_a
  end

  def self.events_for_settings(settings, user=User.current)
    scope = EasyActivity::ALL_SCOPE
    scope = settings['activity_scope'].first if settings['activity_scope']

    selected_event_types = settings['selected_event_types'] || []
    selected_projects = settings['projects'] || nil

    activity_options = { :selected_event_types => selected_event_types,
                         :selected_projects => selected_projects,
                         :custom_event_types => settings['custom_event_types']
                       # commented to show the total number of events
                       #  :limit => row_limit
                       }
    events = EasyActivity.last_events(user, nil, scope, activity_options)
  end

end
