class EasyCustomMenu < ActiveRecord::Base
  belongs_to :easy_user_type, :inverse_of => :easy_custom_menus
  belongs_to :root, class_name: 'EasyCustomMenu', foreign_key: 'root_id', :inverse_of => :submenus

  validates :name, :url, :presence => true
  validates_length_of :url, maximum: 2000

  attr_protected :id

  acts_as_easy_translate

  has_many :submenus, class_name: 'EasyCustomMenu', foreign_key: 'root_id', dependent: :destroy
  accepts_nested_attributes_for :submenus

  def root?
    root_id.nil?
  end

end
