#encoding: utf-8

module EasyIconsHelper

  EASY_ICONS = {
    'icon-remove' => '-',
    'icon-add' => '+',
    'icon-del' => 'K',
    'icon-user' => 'P',
    'icon-group' => 'g',
    'icon-time-add' => '~',
    'icon-timer' => '.',
    'icon-reload' => 'r',
    'icon-lock' => 'L',
    'icon-split' => '|',
    'icon-unlock' => 'U',
    'icon-magnifier' => 'z',
    'icon-templates' => 'p',
    'icon-list' => 'm',
    'icon-slab' => '\5c',
    'icon-bullet-list' => '°',
    'icon-archive' => 'q',
    'icon-adressbook' => 'ů',
    'icon-false' => 'f',
    'icon-edit' => 'e',
    'icon-workflow' => 'W',
    'icon-move' => '=',
    'icon-server' => 'N',
    'icon-package' => '\00a3',
    'icon-home' => 'o',
    'icon-help' => 'H',
    'icon-youtube' => 'Y',
    'icon-dropbox' => '%',
    'icon-aws' => '_',
    'icon-cloud' => 'ú',
    'icon-googledrive' => 'j',
    'icon-time' => 'T',
    'icon-stats' => 'S',
    'icon-warning' => 'w',
    'icon-fullscreen' => '3',
    'icon-fav' => 'v',
    'icon-checked' => 't',
    'icon-checked-circle' => 'n',
    'icon-report' => 'x',
    'icon-comment' => 'b',
    'icon-comments' => 'B',
    'icon-summary' => 'Z',
    'icon-zoom-out' => '0',
    'icon-zoom-in' => '1',
    'icon-watcher' => '4',
    'icon-relation' => '8',
    'icon-integrate' => '9',
    'icon-tracker' => '6',
    'icon-issue-status' => '7',
    'icon-stack' => 'F',
    'icon-help-bubble' => '?',
    'icon-money' => '$',
    'icon-calculation' => 'ø',
    'icon-export' => '<',
    'icon-import' => '>',
    'icon-calendar-month' => 'Q',
    'icon-calendar-week' => 'J',
    'icon-calendar-day' => 'V',
    'icon-linux' => ':',
    'icon-link' => 'l',
    'icon-unlink' => 'u',
    'icon-toggler' => '}',
    'icon-arrow' => ']',
    'icon-close' => 'X',
    'icon-bulb' => 'O',
    'icon-settings' => 's',
    'icon-filter' => 'd',
    'icon-play' => '§',
    'icon-pause' => '!',
    'icon-file' => '/',
    'icon-print' => '^',
    'icon-atom' => ')',
    'icon-csv' => '#',
    'icon-pdf' => '&',
    'icon-html' => '@',
    'icon-project' => 'R',
    'icon-new-document' => 'i',
    'icon-copy' => 'c',
    'icon-issue' => 'I',
    'icon-save' => '2',
    'icon-server-authentication' => 'y',
    'icon-calendar' => 'C',
    'icon-db-key' => 'k',
    'icon-cross-move' => '¶',
    'icon-attachment' => '(',
    'icon-globe' => '\a2',
    'icon-reorder' => '\a4',
    'icon-message' => '\a5',
    'icon-mute' => '\a9',
    'icon-unmute' => '\aa',
    'icon-apple' => '\ab',
    'icon-android' => '\ac',
    'icon-windows' => '\ae',
    'icon-basecamp' => '\af',
    'icon-euro' => '\20ac',
    'icon-person-euro' => '\c0',
    'icon-cash-desk' => '\c1',
    'icon-snowflake' => '\c2',
    'icon-christmas-tree' => '\c3',
    'icon-christmas-ball' => '\c4',
    'icon-present' => '\c5',
    'icon-christmas-linux' => '\c6',
    'icon-agile' => '\c7',
    'icon-ms-project' => '\c8',
    'icon-classic-arrow' => '\c9',
    'icon-heart-o' => '\ca',
    'icon-heart' => '\cb',
    'icon-loading' => '\cc',
    'icon-easy' => '|',
    'icon-logo' => '\ea',
    'icon-cake1' => '\cd',
    'icon-cake2' => '\ce',
    'icon-cake3' => '\cf',
    'icon-falcon' => '\d0',
    'icon-vcard' => '\d1',
    'icon-brick' => '\d2',
    'icon-calc' => '\d3',
    'icon-controls' => '\d4',
    'icon-file-new' => 'G',
    'icon-drop-o' => '\d6',
    'icon-drop' => '\d7',
    'icon-drop-half' => '\d8',
    'icon-drop-empty' => '\d9',
    'icon-zip' => '\da',
    'icon-popup' => '\dc',
    'icon-biohazard' => '\dd',
    'icon-radiation' => '\de',
    'icon-skull' => '\df',
    'icon-people' => '\e0',
    'icon-target-1' => '\e1',
    'icon-target-2' => '\e2',
    'icon-icq' => '\e3',
    'icon-bookmark' => '\e4',
    'icon-rubl' => '\e5',
    'icon-baht' => '\e6',
    'icon-invoice' => '\e7',
    'icon-refresh' => '\e8',
    'icon-crm-1' => '\e9',
    'icon-user-folder' => '\eb',
    'icon-user-target' => '\ec',
    'icon-calculation-2' => '\ed',
    'icon-thumb' => '\ee',
    'icon-thumb-1' => '\ef',
    'icon-thumb-2' => '\f0',
    'icon-award' => '\f2',
    'icon-binoculars' => '\f4',
    'icon-tree' => '\f6',
    'icon-location' => '\f5',
    'icon-move-left' => '\ff',
    'icon-arrow-left' => '\fc',
    'icon-classic-arrow-left' => '\fd',
    'icon-toggler-left' => '\fe',
    'icon-file-xls' => '\100',
    'icon-file-oo' => '\101',
    'icon-file-doc' => '\102',
    'icon-file-point' => '\103',
    'icon-file-adobe' => '\104',
    'icon-file-blank' => '\106',
    'icon-file-css' => '\107',
    'icon-file-xml' => '\108',
    'icon-file-zip' => '\109',
    'icon-puzzle' => '\10a',
    'icon-recycle' => '\10b',
    'icon-calendar-quarter' => '\10c',
    'icon-calendar-year' => '\10d',
    'icon-qr-code' => '\10e',
    'icon-barcode' => '\10f',
    'icon-flashlight-disabled' => '\110',
    'icon-flashlight-on' => '\111',
    'icon-flashlight-off' => '\112',
    'icon-butterfly' => '\113',
    'icon-ruby' => '\114'
  }

  def easy_icon_name_to_char(name)
    EASY_ICONS[name]
  end

  def easy_icon_char_to_name(char)
    EASY_ICONS.key(char)
  end

  def easy_icon_select_tag(name, selected=nil, options={})
    icons = EasyIconsHelper::EASY_ICONS
    select_options = icons.map{|i| {:label => (i[1].gsub(/\\(.*)/, '&#x\1').html_safe), :id => i[0]}}
    selected = {:name => select_options.detect{|o| o[:id] == selected}.try(:[], :label) || '', :id => selected}
    id = name.to_s.tr('[', '_').delete(']')

    icon_tag = ''
    icon_tag << label_tag(id, options[:label]) if options[:label]
    icon_tag << easy_autocomplete_tag(name, selected, select_options, {:html_options => {:id => id, :class => 'easy-icon-select'},
        :render_item => '
                  function (ul, item) {
                    return $("<li class=\'easy-icon-select\'>")
                    .data("item.autocomplete", item)
                    .html(item.label)
                    .appendTo(ul);
                  }',
        :onchange => 'if(ui.item){$(event.target).val($("<div>").html(ui.item.value).text())};'
      })
    icon_tag.html_safe
  end

end
