module EasyAttendancesHelper

  def easy_attandance_tabs
    tabs = [
      {name: 'calendar', partial: 'calendar', label: :label_calendar, redirect_link: true, url: easy_attendances_path(tab: 'calendar')},
      {name: 'list', partial: 'index', label: :label_list, redirect_link: true, url: easy_attendances_path(tab: 'list')},
      {name: 'report', partial: 'report', label: :label_report, redirect_link: true, url: report_easy_attendances_path(tab: 'report', report: {users: @user_ids})},
      {name: 'detailed_report', partial: 'detailed_report', label: :label_detailed_report, redirect_link: true, url: detailed_report_easy_attendances_path(tab: 'detailed_report'), if: proc { User.current.allowed_to_globally?(:view_easy_attendance_other_users) }}
    ]
    tabs.delete_at(0) if in_mobile_view?

    return tabs
  end

  def easy_attendance_indicator(user)
    easy_attendance_indicator_css = 'user easy-attendance-indicator'

    if user.current_attendance && user.current_attendance.easy_attendance_activity.at_work?
      easy_attendance_indicator_css << ' online'
      easy_attendance_indicator = user.current_attendance.easy_attendance_activity.name
    else
      easy_attendance_indicator_css << ' offline'
      if (last_attendance_to_now = user.last_today_attendance_to_now) && !last_attendance_to_now.easy_attendance_activity.at_work?
        easy_attendance_indicator = last_attendance_to_now.easy_attendance_activity.name
      else
        easy_attendance_indicator = l(:label_general_offline)
      end
    end
    [easy_attendance_indicator, easy_attendance_indicator_css]
  end

  def easy_attendance_user_status_indicator(user)
    easy_attendance_indicator, easy_attendace_indicator_css = easy_attendance_indicator(user)

    hook_context = {:user => user, :easy_attendance_indicator => easy_attendance_indicator, :easy_attendace_indicator_css => easy_attendace_indicator_css}
    call_hook(:helper_application_link_to_user_in_easy_attendance, hook_context)

    easy_attendance_indicator = hook_context[:easy_attendance_indicator]

    easy_attendance_indicator = easy_attendance_indicator.join(' ').html_safe if easy_attendance_indicator.is_a?(Array)

    content_tag(:small, easy_attendance_indicator, :class => hook_context[:easy_attendace_indicator_css])
  end

  def easy_format_user_vacation_activity_days(activity, days)
    return '-' if activity.at_work?
    l(:label_day, :count => ('%.2f' % days).to_f)
  end

  def approval_statuses
    l(:approval_statuses, scope: :easy_attendance).map { |key, value| [value, key] }
  end

  def formated_vacation_this_year(activity, user)
    easy_format_user_vacation_activity_days(activity, activity.user_vacation_limit_in_days(user).to_f)
  end

  def formated_remaing_vacation_this_year(activity, user)
    easy_format_user_vacation_activity_days(activity, activity.user_vacation_remaining_in_days(user, Date.current.year).to_f)
  end

end
