class EasyXmlEasyPagesController < EasyXmlDataController

  def import_settings
    render template: 'easy_xml_data/easy_pages_import_settings'
  end

  private

  def entity_mapping
    'easy_page_mapping'
  end

  def create_exporter
    @exporter = EasyXmlData::EasyPageExporter.new(params['id'])
  end

  def get_filename
    if params[:id]
      page_name = EasyPage.where(id: params[:id]).pluck(:user_defined_name).first
      filename = "#{page_name}_#{Time.now}.zip" if page_name
    end
    filename
  end

  def elements_to_validate
    { required_one: ['easy-pages', 'easy-page-templates'] }
  end

end
