class EasyTaggablesController < ApplicationController

  before_action :require_login
  before_action :find_all_tags, :only => [:autocomplete]
  before_action :create_entity_class, :find_entity, :sanitize_tags, :only => [:save_entity]
  before_action :find_tag, :only => [:tag, :destroy]

  helper :easy_query
  include EasyQueryHelper
  helper :sort
  include SortHelper
  helper :custom_fields
  include CustomFieldsHelper
  helper :context_menus
  include ContextMenusHelper

  def index
    respond_to do |format|
      format.html
    end
  end

  def autocomplete
    render :json => @tags
  end

  def save_entity
    @entity.safe_attributes = {'tag_list' => params[:entity][:tag_list]} if params[:entity].is_a?(Hash)
    if @entity.save
      respond_to do |format|
        format.js
      end
    else
      respond_to do |format|
        format.js { render :status => :unprocessable_entity, :text => "showFlashMessage('error', '#{@entity.errors.full_messages.join(',')}')" }
      end
    end
  end

  def tag
    respond_to do |format|
      format.html
    end
  end

  def destroy
    @tag.destroy

    redirect_back_or_default easy_tags_path
  end

  private

  def create_entity_class
    @entity_class = params[:klass].classify.constantize
  rescue
    render_404
  end

  def find_all_tags
    @tags = ActsAsTaggableOn::Tag.joins(:taggings).where(:taggings => {:context => 'tags'}).order('tags.name asc').uniq.pluck(:name)
  end

  def find_entity
    @entity = @entity_class.find(params[:id])
  rescue ActiveRecord::RecordNotFound
    render_404
  end

  def find_tag
    @tag = ActsAsTaggableOn::Tag.named(params[:tag_name]).first
    render_404 if @tag.nil?
  end

  def sanitize_tags
    params[:entity][:tag_list].each{|tag| tag.tr!('.', '-') } if params[:entity].is_a?(Hash)
  end

end
