class EasyPagesController < ApplicationController

  before_action(:except => [:custom_easy_page, :custom_easy_page_layout]) { |c| c.require_admin_or_lesser_admin(:easy_pages_administration) }
  before_action :authorize_global, :if => lambda { !User.current.easy_lesser_admin_for?('easy_pages_administration') }, :only => [:custom_easy_page, :custom_easy_page_layout]
  before_action :find_page, :only => [:show, :edit, :update, :destroy]
  before_action :find_page_from_identifier, :only => [:custom_easy_page, :custom_easy_page_layout]

  def index
    self.class.layout 'admin'
    index_for_easy_query EasyPageQuery, [['identifier', 'asc']]
  end

  def show
  end

  def new
    @page = EasyPage.new
    @page.safe_attributes = params[:easy_page]
  end

  def create
    @page = EasyPage.new
    @page.safe_attributes = params[:easy_page]
    @page.layout_path = EasyPage::PAGE_LAYOUTS[params[:page_layout_identifier]] && EasyPage::PAGE_LAYOUTS[params[:page_layout_identifier]][:path]
    @page.page_name = EasyPage::CUSTOM_PAGE
    @page.is_user_defined = true

    case params[:page_scope_identifier]
    when 'nothing'
      @page.page_scope = nil
    else
      @page.page_scope = params[:page_scope_identifier]
    end

    if @page.save
      @page.install_registered_modules

      respond_to do |format|
        format.html {
          flash[:notice] = l(:notice_successful_create)
          redirect_to( :action => 'index' )
        }
      end
    else
      respond_to do |format|
        format.html { render :action => 'new' }
      end
    end
  end

  def edit
    @page.safe_attributes = params[:easy_page]
  end

  def update
    @page.safe_attributes = params[:easy_page]

    if @page.save
      respond_to do |format|
        format.html {
          flash[:notice] = l(:notice_successful_update)
          redirect_to( :action => 'index' )
        }
      end
    else
      respond_to do |format|
        format.html { render :action => 'edit' }
      end
    end
  end

  def destroy
    @page.destroy

    respond_to do |format|
      format.html {
        flash[:notice] = l(:notice_successful_delete)
        redirect_to( :action => 'index' )
      }
    end
  end

  def custom_easy_page
    render_action_as_easy_page(@page, @page.user, @entity && @entity.id, url_for(:controller => 'easy_pages', :action => 'custom_easy_page', :identifier => @page.identifier, :t => params[:t]), false, {:project => @project, :entity => @entity})
  end

  def custom_easy_page_layout
    render_action_as_easy_page(@page, @page.user, @entity && @entity.id, url_for(:controller => 'easy_pages', :action => 'custom_easy_page', :identifier => @page.identifier, :t => params[:t]), true, {:project => @project, :entity => @entity})
  end

  protected

  def edit_layout_action
    'custom_easy_page_layout'
  end

  private

  def find_page
    @page = EasyPage.find(params[:id])
  rescue ActiveRecord::RecordNotFound
    render_404
  end

  def find_page_from_identifier
    @page = EasyPage.where(:identifier => params[:identifier]).first

    render_404 if @page.nil? || !@page.is_user_defined?
  end

end
