class EasyEntityAssignmentsController < ApplicationController

  before_action :find_project_by_project_id
  before_action :find_source_entity
  before_action :find_entity, :only => [:destroy]
  before_action :create_easy_query, :only => [:index, :update]
  before_action :create_options

  helper :sort
  include SortHelper
  helper :easy_query
  helper :custom_fields

  def index
    sort_init(@easy_query.sort_criteria_init)
    sort_update(@easy_query.sortable_columns)
    render layout: !request.xhr?
  end

  def update
    sort_init(@easy_query.sort_criteria_init)
    sort_update(@easy_query.sortable_columns)
    @easy_query.set_as_default
    render 'index', layout: !request.xhr?
  end

  def destroy
    relation = @source_entity.send(params[:referenced_collection_name])

    relation.delete(@entity)

    respond_to do |format|
      format.js
    end
  end

  private

  def find_source_entity
    begin
      @source_entity = params[:source_entity_type].constantize.find(params[:source_entity_id]) if params[:source_entity_type] && params[:source_entity_id]
    rescue
    end

    render_404 unless @source_entity
  rescue ActiveRecord::RecordNotFound
    render_404
  end

  def find_entity
    begin
      @entity = params[:referenced_entity_type].constantize.find(params[:referenced_entity_id]) if params[:referenced_entity_type] && params[:referenced_entity_id]
    rescue
    end

    render_404 unless @entity
  rescue ActiveRecord::RecordNotFound
    render_404
  end

  def find_project_by_project_id
    @project = Project.find(params.delete(:project_id)) if params[:project_id]
  rescue ActiveRecord::RecordNotFound
    render_404
  end

  def create_easy_query
    @easy_query = EasyQuery.new_subclass_instance(params[:type]) if params[:type]
    return render_404 if @easy_query.nil?
    @easy_query.name = 'Assignment Query'
    @easy_query.user = User.current
    return render_404 if !@source_entity.respond_to?(params[:referenced_collection_name])

    @easy_query.render_context = 'entity_assignments'
    if params[:referenced_collection_name]
      @easy_query.set_entity_scope(@source_entity.send(params[:referenced_collection_name]).visible)
    end
    @easy_query.from_params(params)
    @easy_query.column_names = options[:query_column_names] unless params[:query_column_names].blank?
    @easy_query.group_by = nil
  end

  def create_options
    @options = {}
    # @options[:heading] ||= l("label_#{params[:referenced_entity_type].underscore}_plural", :default => 'Heading')
    @options[:module_name] ||= params[:module_name]
    @options[:referenced_collection_name] ||= params[:referenced_collection_name]
    @options[:module_name] ||= "entity_#{@source_entity.class.name.to_id}_#{@source_entity.id}_#{@options[:referenced_collection_name].to_s}"
    @options[:hascontextmenu] ||= true
    @options[:hide_remove_entity_link] ||= !@source_entity.editable? if @source_entity.respond_to?('editable?')
  end

end
