class EasyEntityActivitiesController < ApplicationController

  include_query_helpers

  before_action :require_login

  before_action :find_easy_entity_activity, only: [:edit, :destroy, :show, :update]

  accept_api_auth :create, :update, :destroy

  def index
    index_for_easy_query EasyEntityActivityQuery, [['start_time', 'desc']]
  end

  def create
    @easy_entity_activity = EasyEntityActivity.new
    build_from_params if request.format.js?
    @easy_entity_activity.safe_attributes = params[:easy_entity_activity]
    respond_to do |format|
      if @easy_entity_activity.save
        build_new_easy_entity_activity

        format.js
        format.api { render_api_ok }
      else
        format.js { render_error :status => 422, :message => @easy_entity_activity.errors.full_messages.join(', ') }
        format.api { render_validation_errors(@easy_entity_activity) }
      end
    end
  end

  def edit
    respond_to do |format|
      format.js
    end
  end

  def update
    build_from_params if request.format.js? && params[:easy_entity_activity_attendees]
    @easy_entity_activity.safe_attributes = params[:easy_entity_activity]
    @easy_entity_activity.start_time = EasyUtils::DateUtils.build_datetime_from_params(params[:easy_entity_activity][:start_time]) if params[:easy_entity_activity][:start_time]
    respond_to do |format|
      if @easy_entity_activity.save
        build_new_easy_entity_activity

        format.js
        format.api { render_api_ok }
      else
        format.js { render_error :status => 422, :message => @easy_entity_activity.errors.full_messages.join(', ') }
        format.api { render_validation_errors(@easy_entity_activity) }
      end
    end
  end

  def destroy
    @easy_entity_activity.destroy

    respond_to do |format|
      format.js
      format.api { render_api_ok }
    end
  end

  private

  def build_from_params
    attendees = params[:easy_entity_activity_attendees]
    @easy_entity_activity.easy_entity_activity_attendees.clear
    attendees.each do |entity_name, ids|
      entity_class = (begin; entity_name.constantize; rescue; nil; end)
      if entity_class && entity_class < ActiveRecord::Base
        entity_class.where(id: ids).each do |entity|
          @easy_entity_activity.easy_entity_activity_attendees.build(entity: entity)
        end
      end
    end if attendees
    @easy_entity_activity.author = User.current
  end

  def find_easy_entity_activity
    @easy_entity_activity = EasyEntityActivity.find(params[:id])
  rescue ActiveRecord::RecordNotFound
    render_404
  end

  def build_new_easy_entity_activity
    @new_easy_entity_activity = @easy_entity_activity.dup
    @new_easy_entity_activity.start_time = Time.now
    @new_easy_entity_activity.is_finished = false
    @new_easy_entity_activity.description = ''
  end
end
