require "#{File.dirname(__FILE__)}/easy_record_token_symbol"

module EasyComputedCustomFields

  class EasyProjectTokenSymbol < EasyComputedCustomFields::EasyRecordTokenSymbol

    def model
      Project
    end

    def identifier
      'project'
    end

    def available_fields
      fields = ['id', 'name', 'sum_time_entries', 'remaining_timeentries', 'start_date', 'due_date', 'created_on', 'sum_estimated_hours']
      fields << 'identifier' if EasySetting.value('project_display_identifiers')
      if Redmine::Plugin.installed?(:easy_helpdesk)
        fields << 'easy_helpdesk_project_spent_time_current_month'
        fields << 'easy_helpdesk_project_spent_time_last_month'
        fields << 'easy_helpdesk_project_monthly_hours'
      end
      fields
    end

    def label_for_field_sum_time_entries
      l(:label_spent_time)
    end

    def set_dependencies( token, custom_field )
      super( token, custom_field )

      if token =~ /%\{#{identifier}_easy_helpdesk.*\}/
        custom_field.easy_dependent_custom_fields.find_or_create_by( dependency_type: 'EasyHelpdeskProject' )
      end
      if token =~ /%\{#{identifier}_sum_time_entries.*\}/
        custom_field.easy_dependent_custom_fields.find_or_create_by( dependency_type: 'TimeEntry' )
      end
    end

  end

end
