require File.expand_path('../../../../../easy_extensions/test/spec/spec_helper', __FILE__)

describe EasyMeeting do

  let(:easy_meeting) { FactoryGirl.create(:easy_meeting, :with_users) }

  it 'includes author if include author is set' do
    easy_meeting.include_author = true
    easy_meeting.save
    expect(easy_meeting.users.include?(easy_meeting.author)).to eq true

    easy_meeting.include_author = false
    easy_meeting.save
    expect(easy_meeting.users.include?(easy_meeting.author)).to eq false
  end

  context 'reccuring' do
    let!(:reccuring_easy_meeting) { FactoryGirl.create(:easy_meeting, :reccuring) }
    let(:rake_task) { EasyRakeTaskRepeatingEntities.new(:active => true, :settings => {}, :period => :daily, :interval => 1, :next_run_at => Time.now) }

    it 'advances by 1 day and generates new uid' do
      with_time_travel(10.day) do
        expect{rake_task.execute}.to change(EasyMeeting, :count).by(1)
      end

      reccuring_easy_meeting.reload
      new_meeting = EasyMeeting.reorder(:id).last

      expect(new_meeting.start_time).to eq(reccuring_easy_meeting.start_time + 1.day)
      expect(new_meeting.end_time).to eq(reccuring_easy_meeting.end_time + 1.day)
      expect(reccuring_easy_meeting.uid).not_to be_blank
      expect(new_meeting.uid).not_to be_blank
      expect(new_meeting.uid).not_to eq reccuring_easy_meeting.uid
    end
  end

end
