require File.expand_path('../../../../../easy_extensions/test/spec/spec_helper', __FILE__)

describe EasyCalendarController, logged: :admin do

  render_views

  context 'with user and module' do
    let!(:page_module) { EasyPageZoneModule.create!(
      easy_pages_id: 1,
      easy_page_available_zones_id: 1,
      easy_page_available_modules_id: 43,
      user_id: User.current.id,
      settings: HashWithIndifferentAccess.new({enabled_calendars: ['easy_meeting_calendar'], display_from: '9:00', display_to: '20:00'})
    )}

    describe 'GET feed' do
      it "works with invalid date limits (happens when module is collapsed)" do
        get :feed, module_id: page_module.id, start: 'NaN', end: 'NaN', format: 'json'
        expect( response ).to be_success
      end
    end


  end

end
