module EasyCalendar
  module ApplicationHelperPatch

    def self.included(base)
      base.send(:include, InstanceMethods)

      base.class_eval do

        def include_dhtmlx_scheduler_headers_tags
          unless @dhtmlx_scheduler_headers_tags_included
            tags = []
            tags << content_tag(:link, '', 'href' => '/plugin_assets/easy_calendar/dhtmlx/dhtmlxscheduler.css', 'rel' => 'stylesheet')
            tags << content_tag(:script, '', 'src' => '/plugin_assets/easy_calendar/dhtmlx/dhtmlxscheduler.js', 'type' => 'text/javascript')
            tags << content_tag(:script, '', 'src' => "/plugin_assets/easy_calendar/dhtmlx/locale/locale_#{I18n.locale.to_s}.js", 'type' => 'text/javascript')
            tags << content_tag(:script, '', 'src' => '/plugin_assets/easy_calendar/dhtmlx/ext/dhtmlxscheduler_recurring.js', 'type' => 'text/javascript')
            tags << content_tag(:script, '', 'src' => '/plugin_assets/easy_calendar/dhtmlx/ext/dhtmlxscheduler_expand.js', 'type' => 'text/javascript')
            tags << content_tag(:script, '', 'src' => '/plugin_assets/easy_calendar/dhtmlx/ext/dhtmlxscheduler_container_autoresize.js', 'type' => 'text/javascript')

            content_for :header_tags do
              tags.join('').html_safe
            end

            @dhtmlx_scheduler_headers_tags_included = true
          end
        end

      end
    end

    module InstanceMethods
    end

  end
end
EasyExtensions::PatchManager.register_helper_patch 'ApplicationHelper', 'EasyCalendar::ApplicationHelperPatch'
