module EasyCalendar
  class Hooks < Redmine::Hook::ViewListener

    include EasyExtensions::EasyAttributeFormatter

    render_on :view_settings_general_webdav, :partial => 'settings/caldav'
    # render_on :view_layout_top_tools, :partial => 'easy_calendar/upcoming_events'
    # render_on :view_layouts_base_html_head, :partial => 'easy_calendar/view_layouts_base_html_head'

    def view_user_allocation_gantt_data_issue(context = {})
      i, api, period = context[:issue], context[:api], context[:period]
      allocation_sums = {}
      if i.estimated_hours.present? && i.assigned_to_id.blank? && curr_date = i.start_date
        context[:user_calendar_cache].load_user_working_hours(:default, period[:from], period[:to])
        hours_left = (100*(i.estimated_hours.to_f - i.spent_hours.to_f)).round.to_f/100
        api.allocation do
          while hours_left > 0
            working_hours = context[:user_calendar_cache].user_working_hours(:default, curr_date).to_f
            if hours_left < working_hours
              allocation_sums[curr_date] = hours_left
              hours_left = 0
            else
              hours_left -= working_hours
              allocation_sums[curr_date] = working_hours
            end
            curr_date += 1.day
          end
        end
        calculated_end = curr_date - 1.day
        api.calculated_end calculated_end
        api.array(:allocations) do
          i.start_date.upto(calculated_end) do |curr_date|
            api.allocation do
              api.hours (allocation_sums[curr_date] || 0)
              api.over false
            end
          end
        end
      end
    end

    def view_user_allocation_gantt_user_allocation(context = {})
      api, user_or_array, curr_date = context[:api], context[:user], context[:date]
      days_working_hours, allocation_sums = context[:days_working_hours], context[:allocation_sums]
      user = user_or_array.is_a?(Array) ? user_or_array.first : user_or_array
      return unless user.present?
      m = context[:user_meetings].select { |m| (m.start_time.to_date..m.end_time.to_date).include?(curr_date) }
      if m.presence
        api.array(:meetings) do
          m.each do |meeting|
            api.meeting do
              api.meeting_name meeting.name
              api.meeting_all_day meeting.all_day
              if meeting.all_day
                api.meeting_hours_text I18n.t(:field_all_day)
                working_hours = days_working_hours[curr_date]
                allocation_sums[curr_date] ? context[:allocation_sums][curr_date] += working_hours : context[:allocation_sums][curr_date] = working_hours
              else
                hours = (meeting.end_time - meeting.start_time) / 1.hour
                api.meeting_hours_text format_hours(hours, no_html: true)
                api.meeting_hours hours
                allocation_sums[curr_date] ? context[:allocation_sums][curr_date] += hours : context[:allocation_sums][curr_date] = hours
              end
            end
          end
        end
      end
    end

  end
end
