class EasyAttendanceCalendarEvent < EasyCalendarEvent

  def title
    t = object.easy_attendance_activity.name
    t += " - #{object.description}" if object.description.present?
    t
  end

  def starts_at
    object.arrival
  end

  def ends_at
    object.departure
  end

  def all_day?
    true
  end

  def location
  end

  def url
    Rails.application.routes.url_helpers.url_for(
      controller: 'easy_attendances',
      action:     'show',
      id:         object.id,
      only_path:  false,
      host: self.class.default_url_options[:host]
    )
  end

  def organizer
    object.try(:user).try(:mail)
  end

end
