module EasyCalendar
  module AdvancedCalendars
    class EasyAttendanceCalendar
      include Rails.application.routes.url_helpers

      def initialize
      end

      def self.label
        'easy_attendance.label'
      end

      def self.permissions; :view_easy_attendances; end

      def events(start_date, end_date)
        user = User.current
        attendances = user.easy_attendances.includes(:easy_attendance_activity).where(:easy_attendance_activities => {:at_work => false})
        attendances = attendances.between(start_date, end_date) if start_date && end_date
        events = attendances.to_a

        events.map! do |event|
          options = {
            id:           "easy_attendance-#{event.id}",
            event_type:   'easy_attendance',
            location:     event.description,
            title:        event.easy_attendance_activity.name,
            start:        user.user_time_in_zone(event.arrival).iso8601,
            end:          user.user_time_in_zone(event.departure).iso8601,
            all_day:      true,
            color:        '#F7A4A4',
            border_color: '#F07777'
          }
          options[:url] = edit_easy_attendance_path(event) if user.allowed_to?(:edit_own_easy_attendances, nil, :global => true) || user.allowed_to?(:edit_easy_attendances, nil, :global => true)
          options
        end
        events
      end

      def project_events(start_date, end_date, project)
        []
      end

      def room_events(start_date, end_date, room)
        []
      end

    end
  end
end

EasyCalendar::AdvancedCalendar.register(EasyCalendar::AdvancedCalendars::EasyAttendanceCalendar) if Redmine::Plugin.installed?(:easy_attendances)
