class EasyRoom < ActiveRecord::Base
  include Redmine::SafeAttributes

  safe_attributes 'name', 'capacity'

  has_many :easy_meetings

  validates :name, :presence => true
  validates :capacity, :numericality => {:allow_nil => true, :only_integer => true, :greater_than => 0}

  attr_protected :id

  def to_s
    name
  end

  def name_with_capacity
    if capacity?
      "#{name} (#{l :label_place, count: capacity})"
    else
      name
    end
  end

end
