class EasyButtonQuery < EasyQuery

  def entity
    EasyButton
  end

  def entity_easy_query_path(options)
    easy_buttons_path options
  end

  def available_filters
    return @available_filters unless @available_filters.blank?
    group = l("label_filter_group_#{self.class.name.underscore}")

    @available_filters = {
      'name' => {:type => :string, :order => 1},
      'active' => {:type => :boolean, :order => 2},
      'is_private' => {:type => :boolean, :order => 3},
      'author_id' => {:type => :list, :order => 4, :values => Proc.new do
        all_users_values
      end
      },
      'entity_type' => {:type => :list, :order => 4, :values => [
        ['Issue', 'Issue'],
        ['EasyCrmCase', 'EasyCrmCase']]
      },
      'created_at' => {:type => :date_period, :order => 6, :group => group},
      'updated_at' => {:type => :date_period, :order => 7, :group => group}
    }

    @available_filters
  end

  def available_columns
    unless @available_columns_added
      group = l("label_filter_group_#{self.class.name.underscore}")
      @available_columns = [
        EasyQueryColumn.new(:name, :sortable => "#{EasyButton.table_name}.name", :groupable => true, :group => group),
        EasyQueryColumn.new(:entity_type, :sortable => "#{EasyButton.table_name}.entity_type", :groupable => true, :group => group),
        EasyQueryColumn.new(:active, :sortable => "#{EasyButton.table_name}.active", :group => group),
        EasyQueryColumn.new(:is_private, :sortable => "#{EasyButton.table_name}.is_private", :group => group),
        EasyQueryColumn.new(:project, :sortable => "#{Project.table_name}.name", :groupable => true, :includes => [:project], :group => group),
        EasyQueryDateColumn.new(:created_at, :sortable => "#{EasyButton.table_name}.created_at", :groupable => true, :group => group),
        EasyQueryDateColumn.new(:updated_at, :sortable => "#{EasyButton.table_name}.updated_at", :groupable => true, :group => group)
      ]

      group = l('label_user_plural')
      @available_columns << EasyQueryColumn.new(:author, :sortable => lambda { User.fields_for_order_statement }, :groupable => true, :includes => [:author => :easy_avatar], :group => group)

      @available_columns_added = true
    end
    @available_columns
  end

  # def default_additional_statement
  #   entity.visible_condition
  # end

  def default_list_columns
    super.presence || ['active', 'name', 'entity_type', 'author', 'is_private']
  end

end
