module EasyAgileBoard
  module EasyQueryOutputs
    class AgileScrumBacklogOutput < AgileScrumOutput

      def self.key
        'scrum_backlog'
      end

      def kanban_data
        return @kanban_data if @kanban_data
        saved_scope = @scope_was
        saved_use_search = query.use_free_search
        saved_filters = @filters_was
        query.filters = nil
        query.entity_scope = saved_scope.joins(:issue_easy_sprint_relation)
                                        .where(issue_easy_sprint_relations: {relation_type: IssueEasySprintRelation::TYPES[IssueEasySprintRelation::TYPE_BACKLOG], easy_sprint_id: query.easy_sprint.id})
        query.use_free_search = false
        @kanban_data = query.entities(fetch: true, limit: 50)
        query.entity_scope = saved_scope.joins(:easy_agile_backlog_relation)
                                        .where(EasyAgileBacklogRelation.arel_table[:project_id].eq(query.easy_sprint.project_id))
        query.sort_criteria = []
        query.instance_variable_set(:@entities, nil)
        @kanban_data.concat(query.entities(fetch: true, limit: 50))
        query.filters = saved_filters
        query.entity_scope = saved_scope.includes(:issue_easy_sprint_relation, :easy_agile_backlog_relation)
                                        .where(EasyAgileBacklogRelation.arel_table[:id].eq(nil).and(IssueEasySprintRelation.arel_table[:id].eq(nil)))
        query.use_free_search = saved_use_search
        query.instance_variable_set(:@entities, nil)
        query.model.instance_variable_set(:@additional_scope, nil)
        @kanban_data.concat(query.entities(fetch: true, limit: 100))

        @kanban_data
      end

      def before_render
        apply_settings
        restore_settings
      end

      def entity_column_filter_value(entity)
        if entity.easy_agile_backlog_relation.try(:project_id) == query.easy_sprint.project_id
          'project_backlog'
        elsif entity.issue_easy_sprint_relation.try(:easy_sprint_id) == query.easy_sprint.id
          entity.issue_easy_sprint_relation.relation_type
        else
          nil
        end
      end

      def entity_column_position(entity)
        if entity.easy_agile_backlog_relation
          entity.easy_agile_backlog_relation.position
        elsif entity.issue_easy_sprint_relation
          entity.issue_easy_sprint_relation.position
        else
          nil
        end
      end

      def apply_settings
        super
        @scope_was = query.entity_scope unless @scope_was
        at = IssueEasySprintRelation.arel_table
        query.entity_scope = @scope_was.preload(:issue_easy_sprint_relation, :easy_agile_backlog_relation)
            .includes(:issue_easy_sprint_relation, :easy_agile_backlog_relation)
            .references(:issue_easy_sprint_relation, :easy_agile_backlog_relation)
            .where( at[:id].eq(nil).or(
                at[:easy_sprint_id].eq(query.easy_sprint.id).and(at[:relation_type].eq(IssueEasySprintRelation::TYPES[IssueEasySprintRelation::TYPE_BACKLOG]))
              )
            )
      end

      def restore_settings
        super
        query.entity_scope = @scope_was
        query.filters = @filters_was
      end

      def kanban_columns
        [
          {
            name: h.l(:label_issues_for_backlog),
            entity_value: '0',
            positioned: false
          },
          {
            name: h.l(:label_project_backlog),
            entity_value: 'project_backlog'
          },
          {
            name: h.l(:label_agile_backlog),
            entity_value: IssueEasySprintRelation::TYPES[IssueEasySprintRelation::TYPE_BACKLOG].to_param
          }
        ]
      end

      def possible_phases(entity)
       ['0', 'project_backlog', IssueEasySprintRelation::TYPES[IssueEasySprintRelation::TYPE_BACKLOG].to_s]
      end

      def required_attribute_names(entity)
       []
      end

      def read_only_attribute_names(entity)
       []
      end

    end
  end
end
