module EasyAgileBoard
  module EntityAttributeHelperPatch

    def self.included(base)
      base.send(:include, InstanceMethods)

      base.class_eval do

        alias_method_chain :format_html_issue_attribute, :easy_agile_board
        alias_method_chain :format_issue_attribute, :easy_agile_board

      end
    end

    module InstanceMethods
      def format_html_issue_attribute_with_easy_agile_board(entity_class, attribute, unformatted_value, options={})
        case attribute.name
        when :'issue_easy_sprint_relation.easy_sprint'
          link_to unformatted_value.name, easy_agile_board_path(unformatted_value.project, sprint_id: unformatted_value) if unformatted_value && unformatted_value.is_a?(EasySprint)
        when :easy_story_points
          css_classes = ''
          if options[:entity].present? && options[:entity].safe_attribute?('easy_story_points')
            css_classes << 'multieditable'
          end
          content_tag(:span, unformatted_value, class: css_classes,
                      data: {
                        name: 'issue[easy_story_points]',
                        type: 'text',
                        value: (unformatted_value.nil? ? '' : unformatted_value)
                      }
          )
        else
          format_html_issue_attribute_without_easy_agile_board(entity_class, attribute, unformatted_value, options)
        end
      end

      def format_issue_attribute_with_easy_agile_board(entity_class, attribute, unformatted_value, options={})
        case attribute.name
        when :'issue_easy_sprint_relation.easy_sprint'
          unformatted_value.name if unformatted_value && unformatted_value.is_a?(EasySprint)
        else
          format_issue_attribute_without_easy_agile_board(entity_class, attribute, unformatted_value, options)
        end
      end
    end

  end

end
EasyExtensions::PatchManager.register_helper_patch 'EntityAttributeHelper', 'EasyAgileBoard::EntityAttributeHelperPatch'
