class EasyAgileBoardQuery < EasyIssueQuery

  attr_accessor :easy_sprint

  def query_after_initialize
    super
    self.display_filter_columns_on_index  = false
    self.display_filter_group_by_on_index = false
    self.display_filter_sort_on_index     = false
    self.display_filter_columns_on_edit   = false
    self.display_filter_group_by_on_edit  = false
    self.display_filter_sort_on_edit      = false
    self.require_is_tagged                = true
    self.export_formats                   = {}
    self.easy_query_entity_controller     = 'easy_agile_board'
    self.easy_query_entity_action         = 'backlog'
  end

  def initialize_available_filters
    super
    group = l("label_filter_group_#{self.class.name.underscore}")
    add_available_filter 'category_id', { type: :list_optional, values: proc { project.issue_categories.reorder(:name).map {|category| [category.name, category.id] } }, group: group }
  end

  def initialize_available_columns
    super
    @available_columns << EasyQueryColumn.new(:kanban_phase, sortable: "#{EasyKanbanIssue.quoted_table_name}.#{quote_column_name('phase')}, #{EasyKanbanIssue.quoted_table_name}.#{quote_column_name('position')}", groupable: true, preload: [:easy_kanban_issue], includes: [:easy_kanban_issue])
    @available_columns << EasyQueryColumn.new(:scrum_phase, sortable: "#{IssueEasySprintRelation.quoted_table_name}.#{quote_column_name('relation_type')}, #{IssueEasySprintRelation.quoted_table_name}.#{quote_column_name('position')}", groupable: true, preload: [:issue_easy_sprint_relation], includes: [:issue_easy_sprint_relation])
    @available_columns << EasyQueryColumn.new(:scrum_backlog, sortable: "#{EasyAgileBacklogRelation.quoted_table_name}.#{quote_column_name('project_id')}", groupable: true, preload: [:issue_easy_sprint_relation], includes: [:issue_easy_sprint_relation])
  end

  # disable searching in custom_fields
  def statement_for_searching
    self.searchable_columns.collect { |column| "(LOWER(#{column}) LIKE ? )" }
  end

  def entity_easy_query_path(options)
    options = options.dup

    if (p = options.delete(:project) || self.project)
      if options.delete(:scrum_backlog).present?
        easy_agile_board_backlog_path(p, options)
      elsif options.delete(:kanban_backlog).present?
        project_easy_kanban_backlog_path(p, options)
      else
        easy_agile_board_path(p, options)
      end
    else
      nil
    end
  end

  def no_params_url_support?
    false
  end

  def to_params
    params = super
    params[:easy_sprint_id] = easy_sprint.to_param
    params
  end

  def from_params(params)
    super
    self.easy_sprint = EasySprint.find(params[:easy_sprint_id]) if params && params[:easy_sprint_id]
  end

  def self.chart_support?
    false
  end

end
