Dir[File.dirname(__FILE__) + '/lib/easy_agile_board/easy_patch/**/*.rb'].each {|file| require_dependency file }

EasyExtensions::PatchManager.register_easy_page_helper 'EasyAgileBoardHelper', 'EasySprintsHelper'

EpmPersonalEasyAgileBoard.register_to_all(:plugin => :easy_agile_board)
EpmEasyKanbanBoard.register_to_all(:plugin => :easy_agile_board)

ActiveSupport.on_load(:easyproject, yield: true) do
  Redmine::MenuManager.map :project_menu do |menu|
    menu.push :easy_scrum_board, { controller: 'easy_agile_board', action: 'show' }, caption: :label_scrum_board
    menu.push :easy_kanban_board, { controller: 'easy_kanban', action: 'show' }, caption: :label_kanban
  end

  Redmine::AccessControl.map do |map|
    map.project_module(:easy_scrum_board) do |pmap|
      pmap.permission :view_easy_scrum_board, {
          easy_agile_board: [:show, :burndown_chart],
          easy_sprints: [:show, :index, :autocomplete]
        }, read: true
      pmap.permission :edit_easy_scrum_board, {
          easy_agile_board: [:show, :settings, :backlog, :recalculate, :reorder_project_backlog, :reorder_sprint_backlog],
          easy_sprints: [:new, :create, :show, :index, :edit, :update, :destroy, :assign_issue, :unassign_issue, :open, :close, :close_dialog, :reorder]
        }
    end

    map.project_module(:easy_kanban_board) do |pmap|
      pmap.permission :view_easy_kanban_board, {
          easy_kanban: [:show, :backlog]
        }, read: true
      pmap.permission :edit_easy_kanban_board, {
          easy_kanban: [:edit, :update, :settings, :recalculate],
          easy_kanban_issues: [:update, :reorder]
        }
    end

    Redmine::MenuManager.map :admin_menu do |menu|
      menu.push :easy_agile_default_settings,
                {controller: 'easy_agile_settings', action: 'index', tab: 'scrum'},
                html: {class: 'icon icon-bullet-list'},
                caption: :easy_agile_default_settings,
                if: Proc.new { User.current.admin? },
                before: :settings
    end
  end
end

ActionDispatch::Reloader.to_prepare do

  require 'easy_agile_board/easy_agile_board'
  require 'easy_agile_board/hooks'
  require 'easy_agile_board/easy_settings'

  EasySetting.map.boolean_keys(:easy_agile_use_workflow_on_sprint, :easy_agile_use_workflow_on_kanban)

  EasyExtensions::EasyQueryHelpers::EasyQueryOutput.register_output EasyAgileBoard::EasyQueryOutputs::KanbanOutput
  EasyExtensions::EasyQueryHelpers::EasyQueryOutput.register_output_for_query EasyAgileBoard::EasyQueryOutputs::AgileScrumOutput, 'EasyAgileBoardQuery'
  EasyExtensions::EasyQueryHelpers::EasyQueryOutput.register_output_for_query EasyAgileBoard::EasyQueryOutputs::AgileScrumBacklogOutput, 'EasyAgileBoardQuery'
  EasyExtensions::EasyQueryHelpers::EasyQueryOutput.register_output_for_query EasyAgileBoard::EasyQueryOutputs::AgileKanbanOutput, 'EasyAgileBoardQuery'
  EasyExtensions::EasyQueryHelpers::EasyQueryOutput.register_output_for_query EasyAgileBoard::EasyQueryOutputs::AgileKanbanBacklogOutput, 'EasyAgileBoardQuery'

  EasyQuery.map do |query|
    query.register EasyAgileBoardQuery
  end

end
