module ActionController
  module MobileFu
    # These are various strings that can be found in mobile devices.  Please feel free
    # to add on to this list.
    MOBILE_USER_AGENTS =  'palm|blackberry|nokia|phone|midp|mobi|symbian|chtml|ericsson|minimo|' +
      'audiovox|motorola|samsung|telit|upg1|windows ce|ucweb|astel|plucker|' +
      'x320|x240|j2me|sgh|portable|sprint|docomo|kddi|softbank|android|mmp|' +
      'pdxgw|netfront|xiino|vodafone|portalmmm|sagem|mot-|sie-|ipod|up\\.b|' +
      'webos|amoi|novarra|cdm|alcatel|pocket|ipad|iphone|mobileexplorer|' +
      'mobile'

    def self.included(base)
      base.extend(ClassMethods)
    end

    module ClassMethods

      # Add this to one of your controllers to use MobileFu.
      #
      #    class ApplicationController < ActionController::Base
      #      has_mobile_fu
      #    end
      #
      # You can also pass any of the options available to before_filter (:only, :exclude)
      #
      #    class WelcomeController < ActionController::Base
      #      has_mobile_fu :only => :index
      #    end
      #
      # You can also force mobile mode by passing in 'true' or :test_mode => true
      #
      #    class ApplicationController < ActionController::Base
      #      has_mobile_fu(true)
      #    end

      def has_mobile_fu(options = {})
        include ActionController::MobileFu::InstanceMethods

        # if options.respond_to?(:delete) && options.delete( :test_mode ) || options === true
        #   before_action :force_mobile_format, options
        # else
        #   before_action :set_mobile_format, options
        # end

        helper_method :is_mobile_device?
        helper_method :in_mobile_view?
        helper_method :is_device?
      end

      def is_mobile_device?
        @@is_mobile_device
      end

      def in_mobile_view?
        @@in_mobile_view
      end

      def is_device?(type)
        @@is_device
      end
    end

    module InstanceMethods

      # Forces the request format to be :mobile

      # def force_mobile_format
      #   request.format = :mobile
      #   session[:mobile_view] = true
      #   User.current.in_mobile_view = true
      # end

      # Determines the request format based on whether the device is mobile or if
      # the user has opted to use either the 'Standard' view or 'Mobile' view.

      def set_mobile_format
        # return if api_request? || request.xhr?
        # if is_mobile_device?
        #   user_agent = request.user_agent.to_s.downcase
        #   if (user_agent =~ /android/ && user_agent !~ /mobile/) || (user_agent =~ /ipad/)
        #     session[:mobile_view] = false if session[:mobile_view].nil?
        #   end
        #   session[:mobile_view] = true if session[:mobile_view].nil?
        #
        #   request.format = :mobile if session[:mobile_view]
        # else
        #   session[:mobile_view] = nil unless is_mobile_device?
        # end
        # User.current.in_mobile_view = session[:mobile_view]
      end

      # Returns either true or false depending on whether or not the format of the
      # request is either :mobile or not.

      def in_mobile_view?
        return false if api_request? || request.xhr?
        is_mobile_device?
      end

      # Returns either true or false depending on whether or not the user agent of
      # the device making the request is matched to a device in our regex.

      def is_mobile_device?
        !(request.user_agent.to_s.downcase =~ Regexp.new(ActionController::MobileFu::MOBILE_USER_AGENTS)).nil?
      end

      # Can check for a specific user agent
      # e.g., is_device?('iphone') or is_device?('mobileexplorer')

      def is_device?(type)
        request.user_agent.to_s.downcase.include?(type.to_s.downcase)
      end
    end

  end

end

ActionController::Base.send(:include, ActionController::MobileFu)
