# DEV Guide - Respositories

1. [Development types](./README.md#code-checking-&-requirements)
   1. [Client modifications](./1_CLIENT_MODIFICATIONS.md)
   2. [Separate existing plugin](./2_SEPARATE_EXISTING_PLUGIN.md)
   3. [Separate new plugin](./3_SEPARATE_NEW_PLUGIN.md)
   4. [Core implementations](./4_CORE_IMPLEMENTATIONS.md)
2. [Development](#development)
3. [Code style](./CODE_STYLE.md)
4. [Common errors](./COMMON_ERRORS.md)
5. **Repositories**
6. [Testing](./TESTS.md)

## easyproject/devel

```

+--------+
| devel  |
+---+----+
    |__________________
                       |
+--------+    +--------v----------+
| early  |<---| early-on-testing  |
+---+----+    +-------------------+
    |__________________
                       |
+--------+    +--------v----------+
| stable |<---| stable-on-testing |
+--------+    +-------------------+
```

- `devel`
  - Hlavní vývojová větev pro nové věci
  - (nejméně stabilní větev)
- `early`
  - Vydaná větev předběžného přístupu
- `early-on-testing `
  - Pro testování early branche a pro opravy bugu
- `stable`
  - Poslední vydána stabilní větev
- `stable-on-testing`
  - Opravy bugu, které se najdou při testování nové verze
  - Všechny MR měřující do této branch podléhájí nejpřísnějšímu hodnocení
  - Nutná maximální opatrnost

## Gantt, Resource management, WBS

```

+-------+    +-------------------+    +--------+
| devel |--->| release_candidate |--->| master |
+---+---+    +-------------------+    +--------+

```

- `devel`
  - Pro nové věci
- `release_candidate`
  - Větev nad kterou se testuje vydání nového balíku
  - Poue opravy bugu
- `master`
  - Stabilní vydaná verze
  - Pouze kritické opravy které nepočkají na testování
