# DEV Guide - Core implementations

1. [Development types](./README.md#code-checking-&-requirements)
   1. [Client modifications](./1_CLIENT_MODIFICATIONS.md)
   2. [Separate existing plugin](./2_SEPARATE_EXISTING_PLUGIN.md)
   3. [Separate new plugin](./3_SEPARATE_NEW_PLUGIN.md)
   4. **Core implementations**
2. [Development](#development)
3. [Code style](./CODE_STYLE.md)
4. [Common errors](./COMMON_ERRORS.md)
5. [Repositories](./REPOSITORIES.md)
6. [Testing](./TESTS.md)

Implementace a úpravy přímo interních pluginu Easy Project. Tedy je brán na kvalitu a předem stanové postupy největší důráz. 

Nedodržení pravidel vede k vrácení kódu.

Tato úroveň také vyžaduje dodržování pravidel ohledně stylu kódu popsané v [sekci code style](./CODE_STYLE.md).

## Code review

Kontroly probíhají od nejdůležitějších po ty nejméně. Důležitost označuje samotná cílová větev nebo label important. Naopak `WIP` jsou brány jako poslední.

#### 1. Kontrola náležitostí

Při nedodržení podmínek z předcházející sekce může mít za následek vrácení MR k doplnění bez jakéhokoliv codereview.

Pokud MR obsahuje konflikt nebo špatnou cílovou větev je automaticky vrácen.

#### 2. O čem to je

Odpoǚedná osoba se musí první informovat o důvodu MR buď z popisu nebo z konkrétního úkolu. Nejesnosti automaticky vedou k vrácení MR.

#### 3. Kontrola kódu

1. CI prošlo?
  - Důvod pokud neprošli. Nahodilé spadnutí 1 testu není problém.
  - Problémy jsou často s feature test na poltregeiste.
2. Lokální test.
  - Větší úpravy se kontrolují na živo. Nejlépe na připraveném deployi nebo lokálbě.
  - Toto testování je pouze orientační a neslouží k otestování funkcionality. Za tu zodpovídá autor a QA tester.
3. Kontrola kódu.
  - Pro tuto problematiku je věnována zvláštní soubor [code style](./CODE_STYLE.md).
4. Hodnocení.
  - Každému MR je přiděleno :+1: nebo :-1:.
  - Podle hodnocení můžou nastat několik možností
    1. Úprava je začleněna
    2. Nebo předáná na kontrolu další osobě
    3. Nebo vrácena zpět k dodělání
