# DEV Guide - Separate existing plugins

1. [Development types](./README.md#code-checking-&-requirements)
   1. [Client modifications](./1_CLIENT_MODIFICATIONS.md)
   2. **Separate existing plugin**
   3. [Separate new plugin](./3_SEPARATE_NEW_PLUGIN.md)
   4. [Core implementations](./4_CORE_IMPLEMENTATIONS.md)
2. [Development](#development)
3. [Code style](./CODE_STYLE.md)
4. [Common errors](./COMMON_ERRORS.md)
5. [Repositories](./REPOSITORIES.md)
6. [Testing](./TESTS.md)

Vývoj/úprava existujicího pluginu pro Redmine, který bude distribuován v rámci Easy Projectu.

Plugin je určený více klientům a tudíž musí být otestován. Buď na úrovni kódu (RSpec, Minitest) nebo definováním scénařů a ručním otestováním.

V těchto pluginech je povoleno využívát pouze vlastní controllery/view. Úpravy jádra jsou povolené **pouze po předchozí domluvě**. V takovémto případě se kontrola patche mění na úroveň [core implementations](#4-core-implementations).

MR může být v opačném případě vráce k přepisu.

Příklad: Easy DMSF

Plugin lze vygenerovat pomoci:

    rails generate redmine_extensions:plugin PLUGIN_NAME

Nápovědu lze získat:

    rails generate redmine_extensions:plugin --help

Na této úrovní vývoje je nutné psát alespoň základní testy pro "touchnutí" rout a otestování úspěšného stavu. Postup pro testování a jeho nastavení lze najít [na této stránce](./TESTS.md)
