class AddEasyChecklist < ActiveRecord::Migration
  def up
    create_table :easy_checklists do |t|
      t.string :name
      t.string :type
      t.integer :author_id, {:null => false}

      t.references :entity
      t.string :entity_type

      t.timestamps :null => false
    end

    add_index :easy_checklists, [:id, :type], :name => 'idx_ecl_type'
    add_index :easy_checklists, [:entity_id, :entity_type], :name => 'idx_ecl_entity_type_id'

    create_table :easy_checklist_items do |t|
      t.string :subject
      t.integer :position
      t.boolean :done, :default => false
      t.integer :author_id, {:null => false}
      t.integer :changed_by_id, {:null => true}
      t.datetime :last_done_change

      t.references :easy_checklist

      t.timestamps :null => false
    end

    create_table :projects_easy_checklists, :id => false do |t|
      t.references :easy_checklist
      t.references :project
    end

    add_index :projects_easy_checklists, :project_id, :name => 'idx_ecl_pec_project_id'
    add_index :projects_easy_checklists, :easy_checklist_id, :name => 'idx_ecl_pec_ecl_id'
  end

  def down
    drop_table :easy_checklists
    drop_table :easy_checklist_items
    drop_table :projects_easy_checklists
  end
end
