
Dir[File.dirname(__FILE__) + '/lib/easy_checklist/easy_patch/**/*.rb'].each {|file| require_dependency file }

# this block is called every time rails are reloading code
# in development it means after each change in observed file
# in production it means once just after server has started
# in this block should be used require_dependency, but only if necessary.
# better is to place a class in file named by rails naming convency and let it be loaded automatically
# Here goes query registering, custom fields registering and so on
ActionDispatch::Reloader.to_prepare do

end

ActiveSupport.on_load(:easyproject, yield: true) do
  require_dependency 'hooks'
  require 'easy_checklist/proposer'

  Redmine::MenuManager.map :admin_menu do |menu|
    menu.push :easy_checklist_templates, :easy_checklists_path, if: proc { User.current.allowed_to_globally?(:manage_easy_checklist_templates) }, html: {class: 'icon icon-workflow'}, before: :settings
  end

  Redmine::AccessControl.map do |map|
    map.project_module :easy_checklists do |pmap|
      pmap.permission :view_easy_checklists, {}
      pmap.permission :create_easy_checklists, {easy_checklists: [:create]}
      pmap.permission :change_easy_checklists_layout, {easy_checklists: [:update_display_mode]}
      pmap.permission :delete_easy_checklists, {easy_checklists: [:destroy]}
      pmap.permission :manage_easy_checklist_templates, {easy_checklists: [:index, :new, :create, :edit, :update, :settings, :destroy]}
      pmap.permission :create_easy_checklist_from_template, {easy_checklists: [:add_to_entity, :append_template]}
      pmap.permission :enable_easy_checklist_items, {easy_checklist_items: [:update]}
      pmap.permission :disable_easy_checklist_items, {easy_checklist_items: [:update]}
      pmap.permission :create_easy_checklist_items, {easy_checklist_items: [:new, :create]}
      pmap.permission :edit_easy_checklist_items, {easy_checklist_items: [:edit, :update]}
      pmap.permission :delete_easy_checklist_items, {easy_checklist_items: [:destroy]}
    end
  end

  RedmineExtensions::EasySettingPresenter.boolean_keys.concat [:easy_checklist_use_project_settings, :easy_checklist_enable_history_changes, :easy_checklist_enable_change_done_ratio]
end
