require 'redmine/plugin'
module Redmine
  class Plugin

    def self.load
      directory = File.join(self.directory, 'easyproject')
      if File.directory?(directory)
        lib = File.join(directory, 'lib')
        if File.directory?(lib)
          $:.unshift lib
          ActiveSupport::Dependencies.autoload_paths += [lib]
        end
        initializer = File.join(directory, 'init.rb')
        if File.file?(initializer)
          require initializer
        end
      end
    end
  end

end
